<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta http-equiv="X-UA-Compatible" content="ie=edge" />
  <link rel="shortcut icon" href="./../favicon.png" type="image/png">
  <link href="https://fonts.googleapis.com/css?family=Raleway:400,300,600" rel="stylesheet" type="text/css">
  <title>Thank you for signing up!</title>
  <link rel="stylesheet" href="./../assets/css/thanks.css">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
</head>

<body>

  <iframe src="../thanks_en.html" title="Thank you!" hidden></iframe>

  <script>
    let newUrl = localStorage.getItem('encodeURL');

    function redirect() {
      window.location.href = newUrl;
    }
    jQuery(function() {
      setTimeout(function() {
        redirect()
      }, 10000);
    });
  </script>


  <div class="cta">
    <div class="container">
      <div class="row">
        <div class="twelve columns congrats">
          <h1>Congratulations! You have registered successfully.</h1>
        </div>
      </div>
    </div>
  </div>

  <div class="show-desktop">
    <div class="agent">
      <div class="container">
        <div class="row">
          <div class="twelve columns second">
            <p class="redirect">You will be redirected in <span id="time"></span> seconds.</p>
            <p class="click">If you aren't redirected automatically, please <a href="javascript:redirect()">click here</a></p>
          </div>
        </div>
        <div class="row">
          <div class="seven columns">
            <img src="./../assets/img/agent_new.webp" />
          </div>
          <div class="five columns">
            <p class="personal">YOUR PERSONAL ADVISOR WILL CALL YOU SHORTLY</p>
            <p class="answer"><span class="important">IMPORTANT:</span> Answer your phone. Your personal advisor will help you get started and guide you through the process.</p>
            <p class="question">We are here for you 24/7 for any questions you may have!</p>
            <p class="start"><a href="javascript:redirect()" class="deposit">Click Here To Get Started »</a></p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="show-mobile">
    <div class="agent">
      <div class="container">
        <div class="row">
          <div class="twelve columns second">
            <p class="redirectMobile">You will be redirected in <span id="time2"></span> seconds.</p>
            <p class="clickMobile">If you aren't redirected automatically, please <a href="javascript:redirect()">click here</a></p>
          </div>
        </div>
        <div class="row">
          <div class="twelve columns">
            <p class="personalMobile">YOUR PERSONAL ADVISOR WILL CALL YOU SHORTLY
              <img class="checkmarkImg" src="./../assets/img/checkmark.webp">
            </p>
            <img class="agentImg" src="./../assets/img/agent_new.webp" />
          </div>
          <div class="twelve columns">
            <p class="answerMobile"><span class="important">IMPORTANT:</span> Answer your phone. Your personal advisor will help you get started and guide you through the process.</p>
            <p class="questionMobile">We are here for you 24/7 for any questions you may have!</p>
            <p class="start"><a href="javascript:redirect()" class="deposit">Click Here To Get Started »</a></p>
          </div>
        </div>
      </div>
    </div>
  </div>



  <!-- Footer -->
  <div class="container">
    <div class="row">
      <div class="twelve columns footer">
        <p>This site is not a news agency, information site or blog. It is a site with promotional material that uses storytelling to illustrate the purpose of the services and products offered.
          Therefore, the stories told on this site are advertisements or publicity material related to information and functions, for a better understanding of the proposed idea.
          General liability limitation: investment activities are very risky and may result in the total loss of the amounts invested. For this reason, these activities may not be suitable for all types of investors.
          You should not invest money that you cannot afford to lose. Before deciding to undertake this type of investment,
          you must be aware of all risks and seek advice from an independent and duly authorized financial advisor.</p>
      </div>
    </div>
  </div>

  <script src="./../assets/js/jquery.min.js"></script>
  <script src="./../assets/js/thanks.js"></script>
</body>

</html>