<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta http-equiv="X-UA-Compatible" content="ie=edge" />
  <link rel="shortcut icon" href="./../favicon.png" type="image/png">
  <link href="https://fonts.googleapis.com/css?family=Raleway:400,300,600" rel="stylesheet" type="text/css">
  <title>Thank you for signing up!</title>
  <link rel="stylesheet" href="./../assets/css/thanks.css">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
</head>

<body>

  <iframe src="../thanks_en.html" title="Thank you!" hidden></iframe>

  <script>
    let newUrl = localStorage.getItem('encodeURL');

    function redirect() {
      window.location.href = newUrl;
    }
    jQuery(function() {
      setTimeout(function() {
        redirect()
      }, 10000);
    });
  </script>


  <div class="cta">
    <div class="container">
      <div class="row">
        <div class="twelve columns congrats">
          <h1>¡Felicidades! ¡Se ha registrado exitosamente!</h1>
        </div>
      </div>
    </div>
  </div>

  <div class="show-desktop">
    <div class="agent">
      <div class="container">
        <div class="row">
          <div class="twelve columns second">
            <p class="redirect">Serás redirigido en <span id="time"></span> segundos.</p>
            <p class="click">Si no es redirigido automáticamente, <a href="javascript:redirect()">haga clic aquí</a></p>
          </div>
        </div>
        <div class="row">
          <div class="seven columns">
            <img src="./../assets/img/agent_new.webp" />
          </div>
          <div class="five columns">
            <p class="personal">ASESOR PERSONAL SE CONTACTARÁ CON USTED EN BREVE</p>
            <p class="answer"><span class="important">IMPORTANTE:</span> Responde tu llamada. Su asesor personal lo asistirá y lo guiará a través del proceso.</p>
            <p class="question">¡Estamos a su disposición las 24 horas del día si tiene alguna pregunta!</p>
            <p class="start"><a href="javascript:redirect()" class="deposit">Haz clic para comenzar »</a></p>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="show-mobile">
    <div class="agent">
      <div class="container">
        <div class="row">
          <div class="twelve columns second">
            <p class="redirectMobile">Serás redirigido en <span id="time2"></span> segundos.</p>
            <p class="clickMobile">Si no es redirigido automáticamente, <a href="javascript:redirect()">haga clic aquí</a></p>
          </div>
        </div>
        <div class="row">
          <div class="twelve columns">
            <p class="personalMobile">ASESOR PERSONAL SE CONTACTARÁ CON USTED EN BREVE
              <img class="checkmarkImg" src="./../assets/img/checkmark.webp">
            </p>
            <img class="agentImg" src="./../assets/img/agent_new.webp" />
          </div>
          <div class="twelve columns">
            <p class="answerMobile"><span class="important">IMPORTANTE:</span> Responde tu llamada. Su asesor personal lo asistirá y lo guiará a través del proceso.</p>
            <p class="questionMobile">¡Estamos a su disposición las 24 horas del día si tiene alguna pregunta!</p>
            <p class="start"><a href="javascript:redirect()" class="deposit">Haz clic para comenzar »</a></p>
          </div>
        </div>
      </div>
    </div>
  </div>



  <!-- Footer -->
  <div class="container">
    <div class="row">
      <div class="twelve columns footer">
        <p>Este sitio web no es una agencia de noticias, un sitio de información o un blog. Es un sitio web que utiliza materiales promocionales narrativos para reflejar el propósito de los servicios y productos ofrecidos. Por lo tanto, las historias de este sitio web también son material publicitario o publicitario relacionado con información y funciones para la comprensión de la idea presentada. Descargo de responsabilidad general: las actividades de inversión son muy riesgosas y pueden resultar en la pérdida total del monto invertido. Por ello, estas actividades no son aptas para todo tipo de inversor. No invierta dinero que no pueda permitirse perder. Antes de decidirse a emprender este tipo de inversión, debe conocer todos los riesgos y buscar el asesoramiento de un asesor financiero independiente y oficial.</p>
      </div>
    </div>
  </div>

  <script src="./../assets/js/jquery.min.js"></script>
  <script src="./../assets/js/thanks.js"></script>
</body>

</html>